/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.world;

import com.google.common.base.Suppliers;
import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class ModConfiguredFeature {
    static final ResourceKey<ConfiguredFeature<?, ?>> STEEL_ORE_KEY = ModConfiguredFeature.registerKey("steel_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STEEL_ORE_DEEPSLATE_ORE_KEY = ModConfiguredFeature.registerKey("steel_ore_deepslate_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LAKE_OIL = ModConfiguredFeature.registerKey("lake_oil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MARS_DIAMOND_ORE_KEY = ModConfiguredFeature.registerKey("mars_diamond_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MARS_ICE_SHARD_ORE_KEY = ModConfiguredFeature.registerKey("mars_ice_shard_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MARS_IRON_ORE_KEY = ModConfiguredFeature.registerKey("mars_iron_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MARS_OSTRUM_ORE_KEY = ModConfiguredFeature.registerKey("mars_ostrum_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MARS_THARSITE_ORE_KEY = ModConfiguredFeature.registerKey("mars_tharsite_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MERCURY_IRON_ORE_KEY = ModConfiguredFeature.registerKey("mercury_iron_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MERCURY_URANIUM_ORE_KEY = ModConfiguredFeature.registerKey("mercury_uranium_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MERCURY_SOLERIUM_ORE_KEY = ModConfiguredFeature.registerKey("mercury_solerium_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOON_CHEESE_ORE_KEY = ModConfiguredFeature.registerKey("moon_cheese_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOON_DESH_ORE_KEY = ModConfiguredFeature.registerKey("moon_desh_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOON_ICE_SHARD_ORE_KEY = ModConfiguredFeature.registerKey("moon_ice_shard_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOON_IRON_ORE_KEY = ModConfiguredFeature.registerKey("moon_iron_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOON_SOUL_SOIL_KEY = ModConfiguredFeature.registerKey("moon_soul_soil_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOON_STEEL_ORE_KEY = ModConfiguredFeature.registerKey("moon_steel_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOON_CAVES = ModConfiguredFeature.registerKey("moon_caves_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOON_VINES = ModConfiguredFeature.registerKey("moon_vine_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VENUS_CALORITE_ORE_KEY = ModConfiguredFeature.registerKey("venus_calorite_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VENUS_COAL_ORE_KEY = ModConfiguredFeature.registerKey("venus_coal_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VENUS_DIAMOND_ORE_KEY = ModConfiguredFeature.registerKey("venus_diamond_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VENUS_GOLD_ORE_KEY = ModConfiguredFeature.registerKey("venus_gold_ore_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VENUS_CORRONIUM_ORE_KEY = ModConfiguredFeature.registerKey("venus_corronium_ore_key");
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MARS_DIAMOND_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MARS_STONE.get()), (BlockState)((Block)BlocksRegistry.MARS_DIAMOND_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MARS_ICE_SHARD_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MARS_STONE.get()), (BlockState)((Block)BlocksRegistry.MARS_ICE_SHARD_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> STEEL_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.STONE), (BlockState)((Block)BlocksRegistry.STEEL_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> STEEL_ORE_DEEPSLATE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest(Blocks.DEEPSLATE), (BlockState)((Block)BlocksRegistry.DEEPSLATE_STEEL_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MARS_IRON_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MARS_STONE.get()), (BlockState)((Block)BlocksRegistry.MARS_IRON_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MARS_OSTRUM_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MARS_STONE.get()), (BlockState)((Block)BlocksRegistry.MARS_OSTRUM_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MARS_THARSITE_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MARS_STONE.get()), (BlockState)((Block)BlocksRegistry.MARS_THARSITE_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MERCURY_IRON_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MERCURY_STONE.get()), (BlockState)((Block)BlocksRegistry.MERCURY_IRON_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MERCURY_URANIUM_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MERCURY_STONE.get()), (BlockState)((Block)BlocksRegistry.MERCURY_URANIUM_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MERCURY_SOLERIUM_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MERCURY_STONE.get()), (BlockState)((Block)BlocksRegistry.MERCURY_SOLERIUM_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MOON_DESH_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MOON_STONE.get()), (BlockState)((Block)BlocksRegistry.MOON_DESH_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MOON_ICE_SHARD_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MOON_STONE.get()), (BlockState)((Block)BlocksRegistry.MOON_ICE_SHARD_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MOON_IRON_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MOON_STONE.get()), (BlockState)((Block)BlocksRegistry.MOON_IRON_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MOON_SOUL_SOIL_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MOON_STONE.get()), (BlockState)Blocks.SOUL_SOIL.defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> MOON_STEEL_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.MOON_STONE.get()), (BlockState)((Block)BlocksRegistry.MOON_STEEL_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> VENUS_COAL_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.VENUS_STONE.get()), (BlockState)((Block)BlocksRegistry.VENUS_COAL_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> VENUS_DIAMOND_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.VENUS_STONE.get()), (BlockState)((Block)BlocksRegistry.VENUS_DIAMOND_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> VENUS_GOLD_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.VENUS_STONE.get()), (BlockState)((Block)BlocksRegistry.VENUS_GOLD_ORE.get()).defaultBlockState())));
    public static final Supplier<List<OreConfiguration.TargetBlockState>> VENUS_CORRONIUM_ORE_REPLACEABLES = Suppliers.memoize(() -> List.of(OreConfiguration.target((RuleTest)new BlockMatchTest((Block)BlocksRegistry.VENUS_STONE.get()), (BlockState)((Block)BlocksRegistry.VENUS_CORRONIUM_ORE.get()).defaultBlockState())));

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocationUtils.id(name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter holderGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        ModConfiguredFeature.register(context, STEEL_ORE_KEY, Feature.ORE, new OreConfiguration(STEEL_ORE_REPLACEABLES.get(), 9));
        ModConfiguredFeature.register(context, STEEL_ORE_DEEPSLATE_ORE_KEY, Feature.ORE, new OreConfiguration(STEEL_ORE_DEEPSLATE_REPLACEABLES.get(), 6));
        ModConfiguredFeature.register(context, MARS_DIAMOND_ORE_KEY, Feature.ORE, new OreConfiguration(MARS_DIAMOND_ORE_REPLACEABLES.get(), 7));
        ModConfiguredFeature.register(context, MARS_ICE_SHARD_ORE_KEY, Feature.ORE, new OreConfiguration(MARS_ICE_SHARD_ORE_REPLACEABLES.get(), 10));
        ModConfiguredFeature.register(context, MARS_IRON_ORE_KEY, Feature.ORE, new OreConfiguration(MARS_IRON_ORE_REPLACEABLES.get(), 11));
        ModConfiguredFeature.register(context, MARS_OSTRUM_ORE_KEY, Feature.ORE, new OreConfiguration(MARS_OSTRUM_ORE_REPLACEABLES.get(), 8));
        ModConfiguredFeature.register(context, MARS_THARSITE_ORE_KEY, Feature.ORE, new OreConfiguration(MARS_THARSITE_ORE_REPLACEABLES.get(), 6));
        ModConfiguredFeature.register(context, MERCURY_IRON_ORE_KEY, Feature.ORE, new OreConfiguration(MERCURY_IRON_ORE_REPLACEABLES.get(), 8));
        ModConfiguredFeature.register(context, MERCURY_URANIUM_ORE_KEY, Feature.ORE, new OreConfiguration(MERCURY_URANIUM_ORE_REPLACEABLES.get(), 4));
        ModConfiguredFeature.register(context, MERCURY_SOLERIUM_ORE_KEY, Feature.ORE, new OreConfiguration(MERCURY_SOLERIUM_ORE_REPLACEABLES.get(), 6));
        ModConfiguredFeature.register(context, MOON_DESH_ORE_KEY, Feature.ORE, new OreConfiguration(MOON_DESH_ORE_REPLACEABLES.get(), 9));
        ModConfiguredFeature.register(context, MOON_ICE_SHARD_ORE_KEY, Feature.ORE, new OreConfiguration(MOON_ICE_SHARD_ORE_REPLACEABLES.get(), 10));
        ModConfiguredFeature.register(context, MOON_IRON_ORE_KEY, Feature.ORE, new OreConfiguration(MOON_IRON_ORE_REPLACEABLES.get(), 11));
        ModConfiguredFeature.register(context, MOON_SOUL_SOIL_KEY, Feature.ORE, new OreConfiguration(MOON_SOUL_SOIL_REPLACEABLES.get(), 60));
        ModConfiguredFeature.register(context, MOON_STEEL_ORE_KEY, Feature.ORE, new OreConfiguration(MOON_STEEL_ORE_REPLACEABLES.get(), 9));
        ModConfiguredFeature.register(context, VENUS_COAL_ORE_KEY, Feature.ORE, new OreConfiguration(VENUS_COAL_ORE_REPLACEABLES.get(), 17));
        ModConfiguredFeature.register(context, VENUS_DIAMOND_ORE_KEY, Feature.ORE, new OreConfiguration(VENUS_DIAMOND_ORE_REPLACEABLES.get(), 9));
        ModConfiguredFeature.register(context, VENUS_GOLD_ORE_KEY, Feature.ORE, new OreConfiguration(VENUS_GOLD_ORE_REPLACEABLES.get(), 10));
        ModConfiguredFeature.register(context, VENUS_CORRONIUM_ORE_KEY, Feature.ORE, new OreConfiguration(VENUS_CORRONIUM_ORE_REPLACEABLES.get(), 6));
        ModConfiguredFeature.register(context, LAKE_OIL, Feature.LAKE, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.simple((BlockState)((LiquidBlock)BlocksRegistry.OIL_BLOCK.get()).defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.STONE.defaultBlockState())));
        ModConfiguredFeature.register(context, MOON_CAVES, Feature.VEGETATION_PATCH, new VegetationPatchConfiguration(BlockTags.MOSS_REPLACEABLE, (BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.MOON_STONE.get())), PlacementUtils.inlinePlaced((Holder)holderGetter.getOrThrow(MOON_VINES), (PlacementModifier[])new PlacementModifier[0]), CaveSurface.CEILING, (IntProvider)UniformInt.of((int)1, (int)2), 0.0f, 5, 0.08f, (IntProvider)UniformInt.of((int)4, (int)7), 0.3f));
    }
}

